import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    vendorProductReviews: [],
    vendorProfileInfo: null,
    loading: true,
    nextPageUrl: "",
    loadMore: false,
};

export const getVendorProductReviews = createAsyncThunk(
    "items/getVendorProductReviews",
    async (URL) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);

const vendorProductReviewsSlice = createSlice({
    name: "items",
    initialState,
    reducers: {
        resetVendorProfile: (state, { payload }) => {
            state.vendorProductReviews = [];
            state.vendorProfileInfo = null;
            state.loadMore = false;
            state.loading = true;
            state.nextPageUrl = "";
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getVendorProductReviews.pending, (state) => {
            if (state.nextPageUrl === "" && state.nextPageUrl !== null) {
                state.loading = true;
            } else if (state.nextPageUrl) {
                state.loadMore = true;
            }
        });
        builder.addCase(getVendorProductReviews.fulfilled, (state, { payload }) => {
            const { data = [], otherData = {}, pagination: { next_page_url } = {} } =
                payload?.records || {};
            let newData = data;
            state.vendorProfileInfo = otherData;
            state.vendorProductReviews = [...state.vendorProductReviews, ...newData];
            state.nextPageUrl = next_page_url;
            state.loading = false;
            state.loadMore = false;
        });
        builder.addCase(getVendorProductReviews.rejected, (state) => {
            state.loading = false;
            state.loadMore = false;
        });
    },
});

export const { resetVendorProfile } = vendorProductReviewsSlice.actions;
export default vendorProductReviewsSlice.reducer;
